*openUBMC xx功能详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware-sig</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.12</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>李东辉</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025/10/23</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>2025/10/23</td>
        <td>1.0</td>
        <td>初稿</td>
        <td>李东辉</td>
        <td>无</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>BMA</td>
        <td>Baseboard Management Agent</td>
        <td>带内管理代理软件</td>
    </tr>
    <tr>
        <td>IO</td>
        <td>Input/Output</td>
        <td>硬盘的输入/输出相应时间受慢盘影响</td>
    </tr>
    <tr>
        <td>SAS</td>
        <td>Serial Attached SCSI</td>
        <td>串行链接SCSI，是硬盘是用的接口协议标准，比如还有NVMe协议</td>
    </tr>
    <tr>
        <td>SSD</td>
        <td>Solid State Drive</td>
        <td>固态硬盘，与之对应的HDD则是机械硬盘</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
1.在某些业务场景中，慢IO会影响业务，比如银行，金融等场景；为了保障相关业务场景的可靠性，可以通过带外慢盘检测算法，对收集IO延时数据进行分析，提前预估
是否出发慢盘告警，与带内业务联动，共同消减慢盘对业务的影响，提升业务可靠性。</br>
2.为了支撑带外慢盘检测算法，需要进行IO延时数据的收集与上报，该详设主要承载硬盘IO延时数据的收集与上报功能。

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
该详设主要实现硬盘IO延时数据的收集与上报，用于提供给故障管理组件进行处理，然后再依赖处理结果确定是否产生硬盘I/O性能下降告警，告警码：0x02000039。

## 1.3 功能场景
<!-- 描述该需求的业务使用场景，内容包括：
1) 场景出发条件及对象：什么角色/工具/接口等在什么具体情况下使用该特性，使用对象技能如何？
2) 使用时间及频度
3) 描述该特性主要有哪些场景、子场景及关键任务操作 -->
1.针对直通NVMe SSD盘，通过带外mctp协议来获取相应的硬盘IO延时数据。<br>
2.针对Raid卡管理的SAS SSD盘，通过Raid卡透传直通命令获取硬盘IO延时数据。<br>
3.针对直通的SAS SSD盘，通过BMA获取相应的硬盘IO延时数据。

## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | 支持直通场景获取华为SAS SSD盘的访问延时数据及传递 | BMA获取统计数据，新增接口触发访问延时数据收集，新增接口将数据上报给故障管理组件 |
| 2 | 支持SSD慢盘事件检测| 故障管理组件根据算法结果返回是否触发告警，慢盘故障恢复后，告警消除 |
| 3 | 支持获取Raid卡管理的华为SAS SSD盘的访问延时统计及传递| 通过Raid卡发送直通命令从硬盘获取访问延时数据，并上报给故障管理组件|
| 4 | 支持获取NVMe SSD盘华为自定义的访问延时统计及传递 | 通过mctp协议从直通NVMe盘中读取访问延时数据，并上报给故障管理组件 |

# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->
[新增和故障管理的交互接口](https://discuss.openubmc.cn/t/topic/3147)
### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->
1.该功能主要内容就是为故障管理组件收集硬盘数据，然后通知storage组件是否要产生硬盘I/O性能下降告警

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->
```mermaid
flowchart TD
    A(开始) --> B[收到CollectDriversInfo请求]
    B --> C[根据可允许收集的类型创建收集任务]
    C --> D[判断硬盘的管理方式]
    D --> E[Raid卡管理的盘]
    D --> F[直通盘,BMA更新数据]
    D --> G[NVMe盘,NVMe协议更新数据]
    E --> H[Raid卡直通命令获取数据]
    F --> I[触发BMA提供的接口获取数据]
    G --> J[通过NVMe Admin Command获取数据]
    H --> L[保存在Drive对象内]
    I --> L
    J --> L
    L --> M(结束)
```

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->
```mermaid
sequenceDiagram
    participant 故障管理组件
    participant Storage
    participant Raid卡适配层
    participant BMA
    participant 硬盘
    participant 告警组件

    故障管理组件->>Storage: 触发CollectDrivesDetails
    par [Raid卡管理硬盘]
    Storage->>Raid卡适配层: 发送直通命令获取
    Raid卡适配层->>Storage: 返回数据
    and [直通盘SAS盘]
    Storage->>BMA: BMA带内收集
    BMA->>Storage: 返回数据
    and [直通NVMe盘]
    Storage->>硬盘: NVMe Admin Comand获取数据
    硬盘->>Storage: 返回数据
    end

    故障管理组件->>Storage: 触发GetDrivesDetails
    Storage->>故障管理组件: 返回数据
    故障管理组件->>故障管理组件: 确定是否产生慢盘告警
    故障管理组件->>Storage: 触发SetDriveSubHealthDiagResult
    Storage->>告警组件: 产生告警0x02000039
```

### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
1.依赖BMA提供触发数据收集的接口
### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->
依赖华为Raid卡， 华为SAS SSD硬盘， 华为NVMe SSD硬盘
### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| 支持获取SSD硬盘访问延时及上报功能 | NA | NA | NA | NA | NA | NA | NA |

### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
新支持功能，不涉及

### 2.1.6 定制化接口分析
<!-- 如果支持定制化设置，则需要给出定制化时的默认值（空定制化项条件下的设置值），如果涉及到定制化接口变更或新增，注意定制化接口文档需配套修改。注意定制化默认值变更对白牌包的影响 -->
通用功能，不涉及

### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
无配置相关功能开发，不涉及

### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
没有新增传感器配置，不涉及

### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
使用已有事件告警码0x02000039，无新增事件

### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
无对外提供接口，接口内部调用，不涉及

### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->
| 用例编号 | 用例描述 | 前置条件 |执行步骤 | 预期结果 |
| --- | --- | --- | --- | --- |
| 1 | 验证通过NVMe Admin Command获取信息是否符合预期 | 华为NVMe SSD盘/OS | 1.通过mdbctl命令触发收集和获取数据；2.通过OS带内NVMe工具获取数据；3.对比数据是否一致 | 数据一致 |
| 2 | 验证通过BMA获取到的信息是否符合预期 | 华为SSD盘/BMA | 1.通过mdbctl命令触发收集和获取数据；2.redfish查询BMA信息；3.对比数据是否一致 | 数据一致 |
| 3 | 验证华为Raid卡管理的SSD硬盘信息获取是否符合预期 | 华为Raid卡/SSD盘/OS | 1.通过mdbctl命令触发收集和获取数据；2.通过OS带内获取数据；3.对比数据是否一致 | 数据一致 |
| 4 | 验证SATA盘/非华为厂商硬盘/非华为Raid卡是否能获取信息 | SATA盘/其他厂商硬盘，Raid卡/BMA| 1.通过mdbctl命令触发收集和获取数据 | 获取不到数据，正常退出 |
| 5 | 告警验证 | SR中配置对应告警 | 1.mdbctl打桩Reading值<br>2.切换触发和消除 | 产生和消除告警 |

## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->
1.暂不涉及

### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->
1.详细参考2.1章节的接口分析

### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->
1.通过mdbctl命令调用，后续补充具体用法
2.带内使用nvme工具
3.BMA相关数据使用redfish获取，后续补充具体uri
### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->
内部功能实现，不涉及客户界面，不涉及

### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->
1.CollectDrivesDetails会起任务处理，内部需要保证task任务正常退出，以及防止task id冲突
2.对单个硬盘，故障管理组件每3小时收集一次，每次收集12组数据，每组数据间隔1分钟

### 2.2.6 可靠性分析
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 跟踪人 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | DC场景 | 收集任务时DC | 任务增加等待机制，超时结束 | 一般 | 超时退出 | 代码防护 | - | - |
| 2 | AC场景 | 收集任务时AC | 任务停止，缓存清空 | 一般 | 无影响 | 无影响 | - | - |
| 3 | 数据获取异常状态 | 数据异常 | 故障管理组件判断数据是否可用 | 一般 | 无影响 | 无影响| - | - |
| 4 | 拔盘/换盘 | Drive对象保存收集到的数据 | 设置为无效值 | 一般 | 对应场景设置默认值 | 代码处理 |- | - |
| 5 | OS重启/BMC重启 | Drive对象保存收集到的数据 | 设置为无效值 | 一般 | 对应场景设置默认值 | 代码处理 |- | - |

### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） | 是 | 接口权限BasicSetting |
| 敏感数据 | 否 | 不涉及 |
| 日志（操作日志、维护日志、安全日志、运行日志） | 是 | 收集日志，获取日志需要打印日志 |
| 文档 | 否 | 不涉及  |
| 加密及算法 | 否 | 不涉及 |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 否 | 不涉及 |
| 新增对外接口入参校验 | 是 | 入参中有对应的type了才进行处理，否则忽略 |
| 新增开源及三方软件引入 | 否 | 不涉及 |
# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->
## 3.1【功能编号】支持直通场景获取华为SAS SSD盘的访问延时数据及传递
### 3.1.1 功能实现设计
直通场景获取场景为：1.直通华为SAS SSD盘；2.依赖带内BMA；
### 3.1.2 功能详细设计
1.故障诊断组件触发收集日志，在storage内部调用BMA提供的接口，暂为提供，假定为：GetIoLatency<br>
2.storage组件在接收到rpc调用后，内部判断代收集硬盘是不是通过BMA提供接口获取<br>
判断条件：Drive.Protocol为2(表示SAS) + Drive.RefControllerId为255<br>
3.将GetIoLatency获取到的结果保存在Drive对象中<br>
4.在故障诊断组件触发收集时，将数据返回
### 3.1.3 开发者测试
#### 3.1.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->

| 组件名 | 用例类型 | 测试用例描述 | 用例名称 | 预置条件 | 操作步骤 | 预期结果 |
| --- | --- | --- | --- | --- | --- | --- |
| storage | UT | 测试从Raid卡获取IO延时数据 | test_get_latency_from_bma | 1.打桩Drive对象<br> | 1.打桩BMA返回的IO延时数据<br/>2.触发收集数据的接口<br/>3.校验获取到的数据| 1.收集到的数据和打桩数据一致 |

#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
不涉及

## 3.2【功能编号】支持SSD慢盘事件检测
### 3.2.1 功能实现设计
当前慢盘事件检测复用：0x02000039不涉及新增，当前已支持
### 3.2.2 功能详细设计
当前能力已支持，不涉及
### 3.2.3 开发者测试
#### 3.2.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->
该部分无代码新增，不涉及用例设计

#### 3.2.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
该部分无代码新增，不涉及用例设计

## 3.3【功能编号】支持获取Raid卡管理的华为SAS SSD盘的访问延时统计及传递
### 3.3.1 功能实现设计
1.场景要求：华为Raid卡，硬盘为SAS SSD盘</br>
### 3.3.2 功能详细设计
1.故障诊断组件发送CollectDrivesDetails时，判断对应的硬盘是否是Raid卡管理的盘</br>
判断条件：Drive.Protocol为2(表示SAS) + Drive.identify_pd不为false</br>
2.适配层新增2个接口：</br>
读/写数据获取-直通命令：</br>
cmd_scsi_passthrough.lun = 0</br>
cmd_scsi_passthrough.cdb_len = 10</br>
cmd_scsi_passthrough.cdb[0] = 0xC0</br>
cmd_scsi_passthrough.cdb[1] = 0x7E</br>
cmd_scsi_passthrough.cdb[2] = 0xF4 // 获取IO延时档位分布信息</br>
cmd_scsi_passthrough.cdb[3] = 0 // 0表示读取读延时统计，1表示读取写延时统计</br>
cmd_scsi_passthrough.cdb[4] = 0x01</br>
// Byte5-6: Reserved</br>
cmd_scsi_passthrough.cdb[7] = 0x03</br>
cmd_scsi_passthrough.cdb[8] = 0x10</br>
// Byte9: Reserved
3.适配层获取到数据之后记录到Drive对象中</br>
4.在故障诊断组件触发收集时，将数据返回</br>

### 3.3.3 开发者测试
#### 3.3.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->
| 组件名 | 用例类型 | 测试用例描述 | 用例名称 | 预置条件 | 操作步骤 | 预期结果 |
| --- | --- | --- | --- | --- | --- | --- |
| storage | UT | 测试从Raid卡获取IO延时数据 | test_get_read_latency_from_raid | 1.打桩Drive对象<br>2.打桩Controller对象 | 1.打桩Raid卡返回的IO读延时数据<br/>2.触发收集数据的接口<br/>3.校验获取到的数据| 1.收集到的数据和打桩数据一致 |
| storage | UT | 测试从Raid卡获取IO延时数据 | test_get_write_latency_from_raid | 1.打桩Drive对象<br>2.打桩Controller对象 | 1.打桩Raid卡返回的IO写延时数据<br/>2.触发收集数据的接口<br/>3.校验获取到的数据| 1.收集到的数据和打桩数据一致 |

#### 3.3.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
不涉及

## 3.4【功能编号】支持获取NVMe SSD盘华为自定义的访问延时统计及传递
### 3.4.1 功能实现设计
1.华为NVMe SSD盘直通。
### 3.4.2 功能详细设计
1.故障诊断组件发送CollectDrivesDetails时，判断对应的硬盘是否是NVMe SSD直通盘</br>
判断条件：Drive.Protocol为6(表示PCIe) + Drive.identify_pd为false</br>
2.读取数据的NVMe Admin Command格式如下：<br>
csi=0<br>
nvme_msg_type=0x02 // 表示NVMe Admin Command<br>
ror=0<br>
meb=0<br>
ciap=0<br>
opcode=0x02 // 表示NVMe Admin Command操作类型为：Get Log Page<br>
cmd_flag=0x03<br>
controller_id=0x01<br>
nsid=0xFFFFFFFF<br>
data_offset=0<br>
data_len=792 // 读写延时数据域长度：98*8+8<br>
log_id=0xc2 // 表示读写延时对应的log page ID，厂商自定义<br>
num_dword_l=-<br>
rae=0<br>
num_dwork_h=-<br>
crc_code=0xC68E53EB<br>
3.获取到的数据流的第一个字节表示的是，厂商自定义该log page的版本，需要传递给故障管理组件<br>
4.在故障诊断组件触发收集时，将数据返回</br>

### 3.4.3 开发者测试
#### 3.4.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->
| 组件名 | 用例类型 | 测试用例描述 | 用例名称 | 预置条件 | 操作步骤 | 预期结果 |
| --- | --- | --- | --- | --- | --- | --- |
| storage | UT | 测试NVMe协议获取IO延时数据 | test_get_latency_from_disk | 1.打桩Drive对象 | 1.打桩硬盘返回的IO延时数据<br/>2.触发收集数据的接口<br/>3.校验获取到的数据| 1.收集到的数据和打桩数据一致 |
#### 3.4.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
不涉及